<?php
/* --------------------------------------------------------------
   FranceVatIdValidator.php 2024-05-31
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\VatValidation\App\Validators;

/**
 * Class FranceVatIdValidator
 *
 * @package Gambio\Core\VatValidation\App\Validators
 */
class FranceVatIdValidator implements ManualVatIdValidator
{
    /**
     * @inheritDoc
     */
    public function validatedCountryIsoCode(): string
    {
        return 'fr';
    }
    
    
    /**
     * @inheritDoc
     */
    public function validateVatId(string $vatId): bool
    {
        return preg_match("/^fr[a-z0-9]{2}[0-9]{9}$/", strtolower($vatId)) === 1;
    }
}